package com.pangding.web.authority.controller;


import com.pangding.web.authority.currency.Result;
import com.pangding.web.authority.service.AuthorityService;
import com.pangding.web.authority.vo.AuthorityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping("/authority")
public class AuthorityController {

    @Autowired
    AuthorityService authorityServiceImpl;

    /**
     * 新增权限
     * @param authorityVo
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveAuthority(@RequestBody AuthorityVo authorityVo){
        authorityServiceImpl.checkValid(authorityVo);
        authorityServiceImpl.save(authorityVo);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 修改权限信息
     * @param authorityVo
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object updateAuthority(@RequestBody AuthorityVo authorityVo){
        authorityServiceImpl.checkValid(authorityVo);
        authorityServiceImpl.update(authorityVo);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 查询权限列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object listAuthoritys(){
        List<AuthorityVo> list = authorityServiceImpl.listAllAuthority();
        if (list == null){
            return new Result(4001,"暂无权限，请先添加",null);
        }
        return new Result(0,"SUCCESS",list);
    }

    /**
     * 查询一级权限
     * @return
     */
    @RequestMapping(value = "/firstLevel", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object parentAuthoritys(){
        List<AuthorityVo> list = authorityServiceImpl.listLevel1();
        if (list == null){
            return new Result(4001,"暂无一级权限，请先添加",null);
        }
        return new Result(0,"SUCCESS",list);
    }

    /**
     * 根据ID查询权限
     * @param id
     * @return
     */
    @RequestMapping(value = "/role/{id}", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object authority(@PathVariable String id){
        AuthorityVo authorityVo = authorityServiceImpl.getAuthorityById(id);
        if (authorityVo == null){
            return new Result(4001,"未查询到该权限",null);
        }
        return new Result(0,"SUCCESS",authorityVo);
    }

    /**
     * 删除权限
     * @param id
     * @return
     */
    @RequestMapping(value = "/delete/{id}", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object delete(@PathVariable String id){

        authorityServiceImpl.deleteAuthorityById(id);
        return new Result(0,"SUCCESS",null);

    }
}


