package com.pangding.web.authority.dao;

import com.pangding.web.authority.reqvo.GetRoleByRoleIdReqVo;
import com.pangding.web.authority.reqvo.GetRoleByRoleNameReqVo;
import com.pangding.web.authority.vo.RoleVo;
import com.yanzuoguang.dao.BaseDao;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface RoleDao extends BaseDao {

    /**
     * 通过主键id获取RoleVo对象
     *
     * @param getRoleByRoleIdReqVo getRoleByRoleIdReqVo对象
     * @return  RoleVo对象
     */
    RoleVo getRoleById(GetRoleByRoleIdReqVo getRoleByRoleIdReqVo);

    /**
     * 通过角色名查询RoleVo对象
     *
     * @param getRoleByRoleNameReqVo 角色名
     * @return RoleVo对象
     */
    RoleVo getRoleByRoleName(GetRoleByRoleNameReqVo getRoleByRoleNameReqVo);

    /**
     * 检查用户名是否已存在
     * 若返回数据大于0，则已存在，该用户名不可用
     * 为0则可用
     *
     * @param roleVo 需要检查的RoleVo对象
     * @return RoleVo对象的用户名在数据库中是否使用过
     */
    void checkNameExist(RoleVo roleVo);

    /**
     * 获取RoleVo对象列表
     *
     * @return RoleVo对象列表
     */
    List<RoleVo> getRoleVoList();

    /**
     * 通过角色id获取子角色列表
     *
     * @param getRoleByRoleIdReqVo 封装角色id
     * @return 角色列表
     */
    List<RoleVo> getChild(GetRoleByRoleIdReqVo getRoleByRoleIdReqVo);

}
