package com.pangding.web.authority.dao;

import com.pangding.web.authority.reqvo.GetUserByCompanyIdReqVo;
import com.pangding.web.authority.reqvo.GetUserByIdReqVo;
import com.pangding.web.authority.vo.UserVo;
import com.yanzuoguang.dao.BaseDao;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface UserDao extends BaseDao {


    /**
     * 检查用户名是否存在
     *
     * @param account 账户名
     * @return UserVo对象
     */
    void checkAccount(UserVo account);

    /**
     * 检查电话号码是否存在
     *
     * @param phone 电话号码
     */
    void checkPhone(UserVo phone);

    /**
     * 获取UserVo对象列表
     *
     * @return UserVo对象列表
     */
    List<UserVo> listUserVo();

    /**
     * 通过用户id查询UserVo对象
     *
     * @param id 用户id
     * @return UserVo对象
     */
    UserVo getUserById(GetUserByIdReqVo id);

    /**
     * 根据公司id获取UserVo对象
     *
     * @param companyId GetUserByCompanyIdReqVo请求对象，封装公司id
     * @return UserVo对象
     */
    UserVo getUserByCompanyId(GetUserByCompanyIdReqVo companyId);
}
