package com.pangding.web.authority.service;

import com.pangding.web.authority.dto.UserDto;
import com.pangding.web.authority.reqvo.GetRoleByRoleIdReqVo;
import com.pangding.web.authority.reqvo.GetUserRoleListByUserIdReqVo;
import com.pangding.web.authority.vo.*;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface UserService {

    /**
     * 保存用户信息，并保存用户和角色的对应关系
     *
     * @param userDto UserDto对象
     */
    void saveUser(UserDto userDto);

    /**
     * 保存更新后的用户信息，并更新用户和角色的对应关系
     *
     * @param userDto UserDto对象
     */
    void updateUser(UserDto userDto);

    /**
     * 检查用户名是否存在
     *
     * @param userVo UserVo对象
     */
    void checkAccount(UserVo userVo);

    /**
     * 检查电话号码是否存在
     *
     * @param userVo UserVo对象
     */
    void checkPhone(UserVo userVo);

    /**
     * 对密码进行MD5盐值加密
     *
     * @param password 密码
     * @return 加密后的密码
     */
    String passwordEncoder(String password);

    /**
     * 获取UserVo对象列表
     *
     * @return UserVo对象列表
     */
    List<UserVo> listUserVo();

    /**
     * 将UserVo对象添加角色id列表和角色名列表封装成UserDto对象
     *
     * @param userVo UserVo对象
     * @param roleIdList 角色id列表
     * @param roleNameList 角色名列表
     * @return UserDto对象
     */
    UserDto makeUserDto(UserVo userVo,List<String> roleIdList,List<String> roleNameList);

    /**
     * 通过用户id查询UserVo对象
     *
     * @param userId 用户id
     * @return UserVo对象
     */
    UserVo getUserById(String userId);

    /**
     * 通过userId查询user和role对应关系对象列表
     *
     * @param reqVo GetUserRoleListByUserIdReqVo对象
     * @return UserRole对应关系对象列表
     */
    List<UserRoleRelation> listUserRoleListByUserId(GetUserRoleListByUserIdReqVo reqVo);

    /**
     * 根据roleId查询RoleVo对象
     *
     * @param getRoleByRoleIdReqVo GetRoleByRoleIdReqVo对象
     * @return RoleVo对象
     */
    RoleVo getRoleByRoleId(GetRoleByRoleIdReqVo getRoleByRoleIdReqVo);

    /**
     * 检查用户名是否合法
     *
     * @param account 用户名
     * @return
     */
    Boolean isValid(String account);

    /**
     * 检查是否为纯数字，用来判断输入的是用户名还是手机号
     *
     * @param account 用户名
     * @return
     */
    Boolean isNumeric(String account);

    /**
     * 通过电话号码获取用户信息
     *
     * @param phone 电话号码
     * @return UserVo对象
     */
    UserVo getUserByPhone(String phone);

    /**
     * 通过用户名获取用户信息
     *
     * @param account 用户名
     * @return UserVo对象
     */
    UserVo getUserByAccount(String account);
}
