package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.RoleDao;
import com.pangding.web.authority.dao.RoleAuthorityDao;
import com.pangding.web.authority.dao.AuthorityDao;
import com.pangding.web.authority.dao.UserRoleDao;
import com.pangding.web.authority.dto.RoleDto;
import com.pangding.web.authority.reqvo.*;
import com.pangding.web.authority.service.RoleService;
import com.pangding.web.authority.vo.*;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangjinyao
 */
@Service
public class RoleServiceImpl implements RoleService {

    @Autowired
    RoleDao roleDao;

    @Autowired
    UserRoleDao userRoleDaoImpl;

    @Autowired
    RoleAuthorityDao roleAuthorityDaoImpl;

    @Autowired
    AuthorityDao authorityDaoImpl;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveRole(RoleDto roleDto) {
        RoleVo roleVo = roleDto;
        roleDao.create(roleVo);
        List<String> authorityIds = roleDto.getAuthorityIds();
        for (String authorityId : authorityIds) {
            RoleAuthorityRelation roleAuthorityRelation = new RoleAuthorityRelation();
            roleAuthorityRelation.setAuthorityId(authorityId);
            roleAuthorityRelation.setRoleId(roleDto.getId());
            roleAuthorityRelation.setId(StringHelper.getNewID());
            roleAuthorityDaoImpl.create(roleAuthorityRelation);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateRole(RoleDto roleDto) {
        RoleVo roleVo = roleDto;
        roleDao.update(roleVo);
        GetRoleAuthorityListByRoleIdReqVo getRoleAuthorityListByRoleIdReqVo = new GetRoleAuthorityListByRoleIdReqVo();
        getRoleAuthorityListByRoleIdReqVo.setRoleId(roleDto.getId());
        List<RoleAuthorityRelation> roleAuthorityList = roleAuthorityDaoImpl.getRoleAuthorityListByRoleId(getRoleAuthorityListByRoleIdReqVo);
        if (roleAuthorityList != null && roleAuthorityList.size() != 0){
            for (RoleAuthorityRelation roleAuthorityRelation:roleAuthorityList) {
                roleAuthorityDaoImpl.remove(roleAuthorityRelation);
            }
        }
        List<String> authorityIds = roleDto.getAuthorityIds();
        for (String authorityId : authorityIds) {
            RoleAuthorityRelation roleAuthorityRelation = new RoleAuthorityRelation();
            roleAuthorityRelation.setAuthorityId(authorityId);
            roleAuthorityRelation.setRoleId(roleDto.getId());
            roleAuthorityRelation.setId(StringHelper.getNewID());
            roleAuthorityDaoImpl.create(roleAuthorityRelation);
        }
    }

    @Override
    public RoleVo getRoleById(String id) {
        GetRoleByRoleIdReqVo getRoleByRoleIdReqVo = new GetRoleByRoleIdReqVo();
        getRoleByRoleIdReqVo.setId(id);
        return roleDao.getRoleById(getRoleByRoleIdReqVo);
    }

    @Override
    public RoleVo getRoleByName(String name) {
        GetRoleByRoleNameReqVo getRoleByRoleNameReqVo = new GetRoleByRoleNameReqVo();
        getRoleByRoleNameReqVo.setName(name);
        return roleDao.getRoleByRoleName(getRoleByRoleNameReqVo);
    }

    @Override
    public void checkNameExist(RoleVo roleVo){
        roleDao.checkNameExist(roleVo);
    }

    @Override
    public List<RoleVo> getRoleVoList() {
        return roleDao.getRoleVoList();
    }

    @Override
    public List<String> getAuthorityIdListByRoleId(String roleId) {
        GetRoleAuthorityListByRoleIdReqVo getRoleAuthorityListByRoleIdReqVo = new GetRoleAuthorityListByRoleIdReqVo();
        getRoleAuthorityListByRoleIdReqVo.setRoleId(roleId);
        List<RoleAuthorityRelation> roleAuthorityRelationList = roleAuthorityDaoImpl.getRoleAuthorityListByRoleId(getRoleAuthorityListByRoleIdReqVo);
        List<String> authorityIdList = new ArrayList(roleAuthorityRelationList.size());
        for (RoleAuthorityRelation roleAuthorityRelation:roleAuthorityRelationList) {
            authorityIdList.add(roleAuthorityRelation.getAuthorityId());
        }
        return authorityIdList;
    }

    @Override
    public String getAuthorityNameByAuthorityId(String authorityId) {
        GetAuthorityByIdReqVo getAuthorityByIdReqVo = new GetAuthorityByIdReqVo();
        getAuthorityByIdReqVo.setId(authorityId);
        AuthorityVo authorityVo = authorityDaoImpl.getAuthorityById(getAuthorityByIdReqVo);
        return authorityVo.getName();
    }

    @Override
    public RoleDto makeRoleDto(RoleVo roleVo, List<String> authorityIdList, List<String> authorityNameList) {
        RoleDto roleDto = new RoleDto();
        roleDto.setId(roleVo.getId());
        roleDto.setName(roleVo.getName());
        roleDto.setPid(roleVo.getPid());
        roleDto.setRemark(roleVo.getRemark());
        roleDto.setAuthorityIds(authorityIdList);
        roleDto.setAuthorityNames(authorityNameList);
        return roleDto;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteRole(RoleVo roleVo) {



        GetUserRoleListByRoleIdReqVo getUserRoleListByRoleIdReqVo = new GetUserRoleListByRoleIdReqVo();
        getUserRoleListByRoleIdReqVo.setRoleId(roleVo.getId());
        List<UserRoleRelation> userRoleList = userRoleDaoImpl.getUserRoleListByRoleId(getUserRoleListByRoleIdReqVo);
        if (userRoleList != null && userRoleList.size() != 0){
            for (UserRoleRelation userRoleRelation:userRoleList) {
                userRoleDaoImpl.remove(userRoleRelation);
            }
        }

        GetRoleAuthorityListByRoleIdReqVo getRoleAuthorityListByRoleIdReqVo = new GetRoleAuthorityListByRoleIdReqVo();
        getRoleAuthorityListByRoleIdReqVo.setRoleId(roleVo.getId());
        List<RoleAuthorityRelation> roleAuthorityList = roleAuthorityDaoImpl.getRoleAuthorityListByRoleId(getRoleAuthorityListByRoleIdReqVo);
        if (roleAuthorityList != null && roleAuthorityList.size() != 0){
            for (RoleAuthorityRelation roleAuthority:roleAuthorityList) {
                roleAuthorityDaoImpl.remove(roleAuthority);
            }
        }

        GetRoleByRoleIdReqVo getRoleByRoleIdReqVo = new GetRoleByRoleIdReqVo();
        getRoleByRoleIdReqVo.setId(roleVo.getId());
        List<RoleVo> childList = roleDao.getChild(getRoleByRoleIdReqVo);
        for (RoleVo child:childList) {
            roleDao.remove(child);
            GetRoleAuthorityListByRoleIdReqVo getRoleAuthorityListByRoleIdReqVo2 = new GetRoleAuthorityListByRoleIdReqVo();
            getRoleAuthorityListByRoleIdReqVo.setRoleId(child.getId());
            List<RoleAuthorityRelation> roleAuthorityList2 = roleAuthorityDaoImpl.getRoleAuthorityListByRoleId(getRoleAuthorityListByRoleIdReqVo2);
            if (roleAuthorityList2 != null && roleAuthorityList2.size() != 0){
                for (RoleAuthorityRelation roleAuthority:roleAuthorityList) {
                    roleAuthorityDaoImpl.remove(roleAuthority);
                }
            }
        }
        roleDao.remove(roleVo);

    }
}
