package com.pangding.web.authority.vo;

import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.InitDao;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * @author zhangjinyao
 */
@TableAnnotation("pd_user")
public class UserVo implements Serializable, InitDao {

    private String id;

    private String account;

    private String password;

    private String phone;

    private String status;

    private String remark;

    @TableAnnotation("create_time")
    private Timestamp createTime;

    private String creator;

    @TableAnnotation("company_id")
    private String companyId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Timestamp getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    @Override
    public void init() {
        String createTimeString = StringHelper.getFirst(DateHelper.getDateTimeString(this.createTime), DateHelper.getNow());
        this.createTime = Timestamp.valueOf(createTimeString);
    }
}
