package com.pangding.web.authority.dao.company.impl;

import com.pangding.web.authority.dao.company.CompanyBankCardDao;
import com.pangding.web.authority.vo.reqvo.CompanyBankCardSetNotDefaultReqVo;
import com.pangding.web.vo.system.pd.company.CompanyBankCardVo;
import com.pangding.web.vo.system.req.company.CompanyBankCardReqVo;
import com.pangding.web.vo.system.res.company.CompanyBankCardResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/5/16 19:17
 */
@Component
public class CompanyBankCardDaoImpl extends BaseDaoImpl implements CompanyBankCardDao {

    private static final String QUERY_BANK_CARD_LIST = "QUERY_BANK_CARD_LIST";
    private static final String UPDATE_DEFAULT = "UPDATE_DEFAULT";

    @Override
    protected void init() {
        register(CompanyBankCardVo.class);

        table.add(QUERY_BANK_CARD_LIST,"select * from pd_company_bank_card where 1=1 ")
                .add("companyId","and company_id = ?");

        table.add(UPDATE_DEFAULT,"update pd_company_bank_card a set a.is_default = @isDefault where 1=1 ")
                .add("id","and id = ?")
                .add("companyId","and company_id = ?");
    }

    @Override
    public PageSizeData<CompanyBankCardResVo> getBankCardListPage(CompanyBankCardReqVo req) {
        return this.queryPage(CompanyBankCardResVo.class, req, QUERY_BANK_CARD_LIST, req);
    }

    @Override
    public List<CompanyBankCardResVo> getBankCardList(CompanyBankCardReqVo req) {
        return this.query(CompanyBankCardResVo.class, QUERY_BANK_CARD_LIST, req);
    }

    @Override
    public void updateDefault(CompanyBankCardReqVo req) {
        this.updateSql(UPDATE_DEFAULT,req);
    }
}
