package com.pangding.web.authority.service.code.impl;

import com.pangding.web.authority.dao.code.CodeModelDao;
import com.pangding.web.authority.dao.code.CodeModelExtendDao;
import com.pangding.web.authority.service.code.CodeModelService;
import com.pangding.web.vo.system.pd.code.CodeModelExtendVo;
import com.pangding.web.vo.system.pd.code.CodeModelVo;
import com.pangding.web.vo.system.req.code.CodeModelReqVo;
import com.pangding.web.vo.system.res.code.CodeModelExtendResVo;
import com.pangding.web.vo.system.res.code.CodeModelResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service
public class CodeModelServiceImpl implements CodeModelService {

    @Autowired
    private CodeModelDao codeModelDao;
    @Autowired
    private CodeModelExtendDao codeModelExtendDao;

    @Override
    public PageSizeData<CodeModelResVo> queryCodeModelPageList(CodeModelReqVo req) {
        return codeModelDao.queryCodeModelPageList(req);
    }

    @Override
    public List<CodeModelResVo> queryCodeModelList(CodeModelReqVo req) {
        return codeModelDao.queryCodeModelList(req);
    }


    @Override
    public List<CodeModelResVo> queryList(CodeModelReqVo req) {
        List<CodeModelExtendResVo> codeModelExtendResVoList = codeModelDao.querylList(req);
        // 子数据
        Map<String, CodeModelResVo> mapTo = new LinkedHashMap<>();
        for (CodeModelExtendResVo item : codeModelExtendResVoList) {
            CodeModelResVo codeModelResVo = mapTo.get(item.getCodeModelId());
            if (codeModelResVo == null) {
                codeModelResVo = new CodeModelResVo();
                ObjectHelper.writeWithFrom(codeModelResVo, item);
                mapTo.put(item.getCodeModelId(), codeModelResVo);
            }
            codeModelResVo.getCodeModelExtendList().add(item);
        }
        List<CodeModelResVo> codeModelResVoList = new ArrayList<>();
        codeModelResVoList.addAll(mapTo.values());
        return codeModelResVoList;
    }




    @Override
    public CodeModelResVo queryCodeModel(CodeModelReqVo req){
        CodeModelResVo codeModelResVo = codeModelDao.load(req, CodeModelResVo.class);
        // 查询码模板扩展信息
        CodeModelExtendVo codeModelExtendVo = new CodeModelExtendVo();
        codeModelExtendVo.setCodeModelId(codeModelResVo.getCodeModelId());
        List<CodeModelExtendVo> codeModelExtendVoList = codeModelExtendDao.loadList(codeModelExtendVo, CodeModelExtendVo.class);
        codeModelResVo.setCodeModelExtendList(codeModelExtendVoList);
        return codeModelResVo;
    }

    @Override
    public CodeModelVo saveCodeModel(CodeModelReqVo req){
        CodeModelVo codeModelVo = new CodeModelVo();
        String codeModelId = req.getCodeModelId();
        if(StringHelper.isEmpty(codeModelId)){
            // 主键不存在，新增  根据码类型和码模板名称去重
            CodeModelReqVo codeModelReqVo = new CodeModelReqVo();
            codeModelReqVo.setCodeType(req.getCodeType());
            codeModelReqVo.setCodeModelName(req.getCodeModelName());
            CodeModelResVo codeModelResVo = codeModelDao.load(codeModelReqVo, CodeModelResVo.class);
            if(StringHelper.isEmpty(codeModelResVo)){
                // 没有该模板 新增
                codeModelId = StringHelper.getNewID();
                ObjectHelper.writeWithFromClass(codeModelVo, req);
                codeModelVo.setCodeModelId( codeModelId);
                codeModelVo.setCreateTime(DateHelper.getNow());
                codeModelDao.create(codeModelVo);
                List<CodeModelExtendVo> codeModelExtendVoList = req.getCodeModelExtendList();
                for (CodeModelExtendVo codeModelExtendVo: codeModelExtendVoList) {
                    codeModelExtendVo.setCodeModelId(codeModelId);
                    codeModelExtendVo.setCodeModelExtendId(StringHelper.getNewID());
                    codeModelExtendDao.create(codeModelExtendVo);
                }
            }else{
                ObjectHelper.writeWithFromClass(codeModelVo, req);
                codeModelVo.setCodeModelId(codeModelResVo.getCodeModelId());
                codeModelDao.update(codeModelVo);
                CodeModelExtendVo delCodeModelExtendVo = new CodeModelExtendVo();
                delCodeModelExtendVo.setCodeModelId(codeModelVo.getCodeModelId());
                codeModelExtendDao.remove(delCodeModelExtendVo);
                List<CodeModelExtendVo> codeModelExtendVoList = req.getCodeModelExtendList();
                for (CodeModelExtendVo codeModelExtendVo: codeModelExtendVoList) {
                    codeModelExtendVo.setCodeModelId(codeModelVo.getCodeModelId());
                    codeModelExtendVo.setCodeModelExtendId(StringHelper.getNewID());
                    codeModelExtendDao.create(codeModelExtendVo);
                }
            }
        }else{
            // 主键存在，修改
            ObjectHelper.writeWithFromClass(codeModelVo, req);
            codeModelDao.update(codeModelVo);
            CodeModelExtendVo delCodeModelExtendVo = new CodeModelExtendVo();
            delCodeModelExtendVo.setCodeModelId(codeModelVo.getCodeModelId());
            codeModelExtendDao.remove(delCodeModelExtendVo);
            List<CodeModelExtendVo> codeModelExtendVoList = req.getCodeModelExtendList();
            for (CodeModelExtendVo codeModelExtendVo: codeModelExtendVoList) {
                codeModelExtendVo.setCodeModelId(codeModelVo.getCodeModelId());
                codeModelExtendVo.setCodeModelExtendId(StringHelper.getNewID());
                codeModelExtendDao.create(codeModelExtendVo);
            }
        }
        return codeModelVo;
    }

    public void removeCodeModel(CodeModelReqVo req){
        CodeModelVo codeModelVo = new CodeModelVo();
        String codeModelId = req.getCodeModelId();
        codeModelVo.setCodeModelId(codeModelId);
        codeModelDao.remove(codeModelVo);
        CodeModelExtendVo delCodeModelExtendVo = new CodeModelExtendVo();
        delCodeModelExtendVo.setCodeModelId(codeModelVo.getCodeModelId());
        codeModelExtendDao.remove(delCodeModelExtendVo);
    }

}
