package com.pangding.web.system.web;

import com.pangding.web.system.service.SystemWarnService;
import com.pangding.web.vo.system.req.SystemWarnPageReqVo;
import com.pangding.web.vo.system.req.SystemWarnReqVo;
import com.pangding.web.vo.system.res.SystemWarnListResVo;
import com.pangding.web.vo.system.res.SystemWarnResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/systemWarn", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "系统预警", description = "系统预警")
public class SystemWarnController {

    private SystemWarnService systemWarnService;

    public SystemWarnController(SystemWarnService systemWarnService) {
        this.systemWarnService = systemWarnService;
    }

    @RequestMapping(value = "/findSystemWarnList")
    @ApiOperation(value = "查询预警信息", notes = "返回预警信息列表.")
    public ResponseResult<SystemWarnListResVo> findSystemWarnList(@RequestBody SystemWarnPageReqVo req) {
        return ResponseResult.result(systemWarnService.findListPage(req));
    }

    @RequestMapping(value = "/findSystemWarn")
    @ApiOperation(value = "查询预警信息详情", notes = "返回预警信息详情.")
    public ResponseResult<SystemWarnResVo> findSystemWarn(@RequestBody SystemWarnReqVo req) {
        return ResponseResult.result(systemWarnService.find(req));
    }

}
