package com.pangding.web.authority.controller;


import com.pangding.web.authority.currency.Result;
import com.pangding.web.authority.dto.RoleDto;
import com.pangding.web.authority.service.RoleService;
import com.pangding.web.authority.vo.RoleVo;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping("/roles")
public class RoleController {

    @Autowired
    RoleService roleServiceImpl;

    /**
     * 新增角色
     * @param roleDto
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveRole(@RequestBody RoleDto roleDto){
        RoleVo roleVo = roleDto;
        roleServiceImpl.checkNameExist(roleVo);
        roleDto.setId(StringHelper.getNewID());
        roleServiceImpl.saveRole(roleDto);
        return new Result(0,"SUCCESS",null);
    }

    /**
     * 修改角色信息
     * @param roleDto
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object updateRole(@RequestBody RoleDto roleDto){
        RoleVo roleVo = roleDto;
        roleServiceImpl.checkNameExist(roleVo);
        roleServiceImpl.updateRole(roleDto);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 查询角色列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object listRoles(){
        List<RoleVo> roleVoList = roleServiceImpl.getRoleVoList();
        List<RoleDto> roleDtoList = new ArrayList(roleVoList.size());
        if (roleVoList == null || roleVoList.size() == 0){
            return new Result(0,"暂无角色信息",null);
        }
        for (RoleVo roleVo:roleVoList) {
            List<String> authorityIdList = roleServiceImpl.getAuthorityIdListByRoleId(roleVo.getId());
            List<String> authorityNameList = new ArrayList(authorityIdList.size());
            for (String authorityId:authorityIdList) {
                String authorityName = roleServiceImpl.getAuthorityNameByAuthorityId(authorityId);
                authorityNameList.add(authorityName);
            }
            RoleDto roleDto = roleServiceImpl.makeRoleDto(roleVo,authorityIdList,authorityNameList);
            roleDtoList.add(roleDto);
        }
        Result result = new Result(0,"SUCCESS",roleDtoList);
        return result;
    }



    /**
     * 根据ID查询角色
     * @param
     * @return
     */
    @RequestMapping(value = "/role/{roleId}", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object getRoleById(@PathVariable String roleId){
        RoleVo roleVo = roleServiceImpl.getRoleById(roleId);
        if(roleVo == null){
            return new Result(4001,"未查询到该角色",null);
        }
        List<String> authorityIdList = roleServiceImpl.getAuthorityIdListByRoleId(roleId);
        List<String> authorityNameList = new ArrayList(authorityIdList.size());
        for (String authorityId:authorityIdList) {
            String authorityName = roleServiceImpl.getAuthorityNameByAuthorityId(authorityId);
            authorityNameList.add(authorityName);
        }
        RoleDto roleDto = roleServiceImpl.makeRoleDto(roleVo,authorityIdList,authorityNameList);
        Result result = new Result(0,"SUCCESS",roleDto);
        return result;
    }

    /**
     * 删除角色
     * @param
     * @return
     */
    @RequestMapping(value = "/delete/{roleId}", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object delete(@PathVariable String roleId){
        RoleVo roleVo = roleServiceImpl.getRoleById(roleId);
        roleServiceImpl.deleteRole(roleVo);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }
}
