package com.tcm.common.dao;

import com.tcm.util.area.FloorVo;
import com.tcm.util.area.req.FloorLoadPageReqVo;
import com.tcm.util.area.req.FloorReqVo;
import com.tcm.util.area.res.FloorResVo;
import com.yanzuoguang.dao.BaseDao;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

public interface FloorDao extends BaseDao {
    /**
     * 排序查询
     * @param req
     * @return
     */
    List<FloorResVo> loadBySort(FloorReqVo req);

    /**
     * 分页加载
     * @param req
     * @return
     */
    PageSizeData<FloorResVo> loadByPage(FloorLoadPageReqVo req);

    /**
     * 单独加载
     * @param floor
     * @return
     */
    FloorResVo loadInfo(FloorReqVo floor);
}
