package com.tcm.common.service.impl;

import com.tcm.common.dao.ImageDao;
import com.tcm.common.service.ImageService;
import com.tcm.util.common.ImageVo;
import com.tcm.util.common.req.ImageReqVo;
import com.tcm.util.common.res.ImageResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.stereotype.Service;

import java.awt.*;
import java.util.ArrayList;
import java.util.List;

@Service
public class ImageServiceImpl implements ImageService {

    private final ImageDao imageDao;

    public ImageServiceImpl(ImageDao imageDao) {
        this.imageDao = imageDao;
    }

    @Override
    public String save(ImageReqVo req) {
        if (StringHelper.isEmpty(req.getImageId())) {
            ImageVo image = new ImageVo();
            String imageId = StringHelper.getNewID();
            ObjectHelper.writeWithFrom(image, req);
            image.setImageId(imageId);
            image.setCreateTime(DateHelper.getNow());
            imageDao.save(image);
            return imageId;
        } else {
            ImageVo image = new ImageVo();
            image.setImageId(req.getImageId());
            ImageVo load = imageDao.load(image, ImageVo.class);
            ObjectHelper.writeWithFrom(load, req);
            load.setUpdateTime(DateHelper.getNow());
            imageDao.update(load);
            return req.getImageId();
        }
    }

    @Override
    public ImageResVo load(ImageReqVo req) {
        ImageVo image = new ImageVo();
        image.setImageId(req.getImageId());
        return imageDao.load(image, ImageResVo.class);
    }

    @Override
    public String remove(ImageReqVo req) {
        ImageVo image = new ImageVo();
        image.setImageId(req.getImageId());
        imageDao.remove(image);
        return image.getImageId();
    }

    @Override
    public List<ImageResVo> homeBanner(ImageReqVo req) {
        ImageVo image = new ImageVo();
        image.setImageType(req.getImageType());
        image.setImageStatus(req.getImageStatus());
        return imageDao.loadList(image, ImageResVo.class);
    }

    @Override
    public List<ImageResVo> loadList(ImageReqVo req) {
        ImageVo image = new ImageVo();
        ObjectHelper.writeWithFrom(image, req);
        return imageDao.loadList(image, ImageResVo.class);
    }

    @Override
    public String saveList(ImageReqVo imageReqVo) {
        List<ImageVo> imageList = new ArrayList<>();
        for (ImageVo imageVo : imageReqVo.getImageList()) {
            ImageVo image = new ImageVo();
            ObjectHelper.writeWithFrom(image, imageReqVo);
            image.setImageId(StringHelper.getNewID());
            image.setCreateTime(DateHelper.getNow());
            image.setImageUrl(imageVo.getImageUrl());
            imageList.add(image);
        }
        imageDao.createList(imageReqVo.getImageList());
        return imageReqVo.getRelationId();
    }
}
